/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jeirei;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.FillCraftingGridFromRecipePacket;
import appeng.integration.modules.jeirei.EncodingHelper;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.util.CraftingRecipeUtil;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public final class CraftingHelper {
    private static final Comparator<GridInventoryEntry> ENTRY_COMPARATOR = Comparator.comparing(GridInventoryEntry::getStoredAmount);

    private CraftingHelper() {
    }

    public static void performTransfer(CraftingTermMenu menu, Recipe<?> recipe, boolean craftMissing) {
        NonNullList<ItemStack> templateItems = CraftingHelper.findGoodTemplateItems(recipe, menu);
        ResourceLocation recipeId = recipe.m_6423_();
        if (menu.getPlayer().f_19853_.m_7465_().m_44043_(recipe.m_6423_()).isEmpty()) {
            AELog.debug("Cannot send recipe id %s to server because it's transient", recipeId);
            recipeId = null;
        }
        NetworkHandler.instance().sendToServer(new FillCraftingGridFromRecipePacket(recipeId, templateItems, craftMissing));
    }

    private static NonNullList<ItemStack> findGoodTemplateItems(Recipe<?> recipe, MEStorageMenu menu) {
        Map<AEKey, Integer> ingredientPriorities = EncodingHelper.getIngredientPriorities(menu, ENTRY_COMPARATOR);
        NonNullList templateItems = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        NonNullList<Ingredient> ingredients = CraftingRecipeUtil.ensure3by3CraftingMatrix(recipe);
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (ingredient.m_43947_()) continue;
            ItemStack stack = ingredientPriorities.entrySet().stream().filter(e -> {
                AEItemKey itemKey;
                Object patt2466$temp = e.getKey();
                return patt2466$temp instanceof AEItemKey && ingredient.test((itemKey = (AEItemKey)patt2466$temp).toStack());
            }).max(Comparator.comparingInt(Map.Entry::getValue)).map(e -> ((AEItemKey)e.getKey()).toStack()).orElse(ingredient.m_43908_()[0]);
            templateItems.set(i, (Object)stack);
        }
        return templateItems;
    }
}

